local PANEL = {};

// link to class
function PANEL:LinkToClass( cls )
	self.LinkedClass = cls;
	
end

// button.
function PANEL:Init( )
	// disable mouse input.
	self:SetMouseInputEnabled( false );
	
	// label.
	self.Label = vgui.Create( "label", self );
	self.Label:SetMouseInputEnabled( false );
	
	// linked to
	self.LinkedClass = nil;
	
end


// set text
function PANEL:SetText( txt )
	self.Label:SetText( txt );
	
end

// think
function PANEL:Think( )
	// stick to mouse.
	local x, y = gui.MousePos();
	self:SetPos( x, y - self:GetTall() );
	
end

// perform layout
function PANEL:PerformLayout( )
	// position label.
	self.Label:SizeToContents();
	
	// width/height
	local width, height = self:GetSize();
	local lwidth, lheight = self.Label:GetSize();
	
	// size
	self:SetSize( lwidth + 8, lheight + 4 );
	
	// set
	self.Label:SetPos(
		height * 0.5 - lheight * 0.5,
		4
	);
	
end

// scheme
function PANEL:ApplySchemeSettings( )
	self.Label:SetFont( AppFramework:Theme().fonts['text'] );
	self.Label:SetFGColor( AppFramework:Theme().colors['text'] );
	
end


// draw
function PANEL:Paint( )
	// calculate color.
	local color = AppFramework:CopyColor( AppFramework:Theme().colors['selection'] );
	
	// calculate delta
	local delta = math.sin( CurTime() * 8 ) * 15;
	
	// adjust color, clamping to the valid range.
	color.r = math.Clamp( color.r + delta, 0, 255 );
	color.g = math.Clamp( color.g + delta, 0, 255 );
	color.b = math.Clamp( color.b + delta, 0, 255 );
	color.a = 255;
	
	// draw.
	AppFramework:Theme():DrawFrame( 0, 0, self:GetWide(), self:GetTall(), FRAME_OUTSET, color );
	
	//
	return true;
	
end

// register
vgui.Register( "ctl_tooltip", PANEL, "Panel" );




// create app framework control.
CtlTooltip_class 	= Control_class:create( nil, false, "ctl_tooltip" );

// set text
function CtlTooltip_class:SetText( txt )
	self:GetHandle():SetText( txt );	

end
